
#include "sound.h"

SoundS::SoundS(char *name) 
{
	n1 = name;
}

int SoundS::init() {
	// Get list of available Capture Devices
	const ALchar *pDeviceList = alcGetString(NULL, ALC_CAPTURE_DEVICE_SPECIFIER);
	if (pDeviceList)
	{
		printf("\nAvailable Capture Devices are:-\n");

		while (*pDeviceList)
		{
			printf("%s\n", pDeviceList);
			pDeviceList += strlen(pDeviceList) + 1;
		}
	}

	// Get the name of the 'default' capture device
	szDefaultCaptureDevice = alcGetString(NULL, ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER);
	printf("\nDefault Capture Device is '%s'\n\n", szDefaultCaptureDevice);

	pCaptureDevice = alcCaptureOpenDevice(szDefaultCaptureDevice, 22050, AL_FORMAT_MONO16, BUFFERSIZE);

	// Create / open a file for the captured data
	pFile = fopen(n1, "wb");

	return 1;
}

int SoundS::record() 
{
	if (pCaptureDevice)
	{
		printf("Opened '%s' Capture Device\n\n", alcGetString(pCaptureDevice, ALC_CAPTURE_DEVICE_SPECIFIER));

		// Prepare a WAVE file header for the captured data
		sprintf(sWaveHeader.szRIFF, "RIFF");
		sWaveHeader.lRIFFSize = 0;
		sprintf(sWaveHeader.szWave, "WAVE");
		sprintf(sWaveHeader.szFmt, "fmt ");
		sWaveHeader.lFmtSize = sizeof(WAVEFORMATEX);		
		sWaveHeader.wfex.nChannels = 1;
		sWaveHeader.wfex.wBitsPerSample = 16;
		sWaveHeader.wfex.wFormatTag = WAVE_FORMAT_PCM;
		sWaveHeader.wfex.nSamplesPerSec = 22050;
		sWaveHeader.wfex.nBlockAlign = sWaveHeader.wfex.nChannels * sWaveHeader.wfex.wBitsPerSample / 8;
		sWaveHeader.wfex.nAvgBytesPerSec = sWaveHeader.wfex.nSamplesPerSec * sWaveHeader.wfex.nBlockAlign;
		sWaveHeader.wfex.cbSize = 0;
		sprintf(sWaveHeader.szData, "data");
		sWaveHeader.lDataSize = 0;

		fwrite(&sWaveHeader, sizeof(WAVEHEADER), 1, pFile);

		// Start audio capture
		alcCaptureStart(pCaptureDevice);

		// Record for two seconds or until a key is pressed
		DWORD dwStartTime = timeGetTime();
		while ((timeGetTime() <= (dwStartTime + 5000)))
		{
			// Release some CPU time ...
			Sleep(1);

			// Find out how many samples have been captured
			alcGetIntegerv(pCaptureDevice, ALC_CAPTURE_SAMPLES, 1, &iSamplesAvailable);

			printf("Samples available : %d\r", iSamplesAvailable);

			// When we have enough data to fill our BUFFERSIZE byte buffer, grab the samples
			if (iSamplesAvailable > (BUFFERSIZE / sWaveHeader.wfex.nBlockAlign))
			{
				// Consume Samples
				alcCaptureSamples(pCaptureDevice, Buffer, BUFFERSIZE / sWaveHeader.wfex.nBlockAlign);

				// Write the audio data to a file
				fwrite(Buffer, BUFFERSIZE, 1, pFile);

				// Record total amount of data recorded
				iDataSize += BUFFERSIZE;
			}
		}

		// Stop capture
		alcCaptureStop(pCaptureDevice);

		// Check if any Samples haven't been consumed yet
		alcGetIntegerv(pCaptureDevice, ALC_CAPTURE_SAMPLES, 1, &iSamplesAvailable);
		while (iSamplesAvailable)
		{
			if (iSamplesAvailable > (BUFFERSIZE / sWaveHeader.wfex.nBlockAlign))
			{
				alcCaptureSamples(pCaptureDevice, Buffer, BUFFERSIZE / sWaveHeader.wfex.nBlockAlign);
				fwrite(Buffer, BUFFERSIZE, 1, pFile);
				iSamplesAvailable -= (BUFFERSIZE / sWaveHeader.wfex.nBlockAlign);
				iDataSize += BUFFERSIZE;
			}
			else
			{
				alcCaptureSamples(pCaptureDevice, Buffer, iSamplesAvailable);
				fwrite(Buffer, iSamplesAvailable * sWaveHeader.wfex.nBlockAlign, 1, pFile);
				iDataSize += iSamplesAvailable * sWaveHeader.wfex.nBlockAlign;
				iSamplesAvailable = 0;
			}
		}

		// Fill in Size information in Wave Header
		fseek(pFile, 4, SEEK_SET);
		iSize = iDataSize + sizeof(WAVEHEADER) - 8;
		fwrite(&iSize, 4, 1, pFile);
		fseek(pFile, 42, SEEK_SET);
		fwrite(&iDataSize, 4, 1, pFile);

		printf("\nSaved captured audio data to '%s'\n", n1);

		// Close the Capture Device
		alcCaptureCloseDevice(pCaptureDevice);

		SoundS::close();
	}

	return 1;
}

int SoundS::close() 
{
	fclose(pFile);

	return 1;
}

SoundS::~SoundS() 
{

}